/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       AdcFltr_Cfg.h
  \brief      ADC Filter Configuration and Control parameters
  \author     Freescale Semiconductor
  \author     R01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    1.0
  \date       12/08/2008 12:33:36 PM

  * History:
  
*/
/****************************************************************************************/
#include "Adc_Cfg.h"
#include "typedefs.h"
#include "AdcFltr_Test_Case.h"
/*------------------------------------------- Defines -----------------------------------------------------*/

/*------------------------------------ ADC Filter Control Parameters ---------------------------------*/

/** Number of samples per ADC Channel. Maximum allowed is 64 */
#define _2_SAMPLE_DEPTH_         1U
#define _4_SAMPLE_DEPTH_         2U
#define _8_SAMPLE_DEPTH_         3U
#define _16_SAMPLE_DEPTH_        4U
#define _32_SAMPLE_DEPTH_        5U
#define _64_SAMPLE_DEPTH_        6U
#define _INVALID_SAMPLE_DEPTH_   10U


#if ((ADCFLTR_TC001 == ON) || (ADCFLTR_TC002 == ON) || (ADCFLTR_TC004 == ON))
  #define SAMPLE_AVERAGE_VALUE      _8_SAMPLE_DEPTH_  
#endif

#if (ADCFLTR_TC003 == ON)
  /** Indicates the driver the number of samples to be acquired per channel          */
  #define SAMPLE_AVERAGE_VALUE      _INVALID_SAMPLE_DEPTH_  
#endif
#if ((ADCFLTR_TC005 == ON) || (ADCFLTR_TC009 == ON))
  #define SAMPLE_AVERAGE_VALUE      _8_SAMPLE_DEPTH_  
#endif

#if (ADCFLTR_TC006 == ON) 
  #define SAMPLE_AVERAGE_VALUE      _4_SAMPLE_DEPTH_  
#endif

#if (ADCFLTR_TC007 == ON) 
  #define SAMPLE_AVERAGE_VALUE      _16_SAMPLE_DEPTH_  
#endif

#if (ADCFLTR_TC008 == ON) 
  #define SAMPLE_AVERAGE_VALUE      _32_SAMPLE_DEPTH_  
#endif


/** Used by the eDMA module to indicate the number of ADC conversions to be stored */
#define RQUEUE_BUFF_DEPTH       3U
#define FLTR_RESET_VALUE        0x0000U

/*-------------------------------- ADC Filter Configuration Parameters ------------------------------------*/

/* For each filtered ATD create and assign the following parameters */
/** Create filter 0                                                 */
#define ATDFLTR_0_AVERAGE   

#if ((ADCFLTR_TC001 == ON) || (ADCFLTR_TC002 == ON) || (ADCFLTR_TC003 == ON) || (ADCFLTR_TC004 == ON))
/** 1..8/16 ; number of active channels used on this ADC            */
#define ATDFLTR_0_AVERAGECHANNELS      4U  
#endif

#if ((ADCFLTR_TC005 == ON) || (ADCFLTR_TC008 == ON) || (ADCFLTR_TC009 == ON))
/** 1..8/16 ; number of active channels used on this ADC            */
#define ATDFLTR_0_AVERAGECHANNELS      4U  
#endif

#if (ADCFLTR_TC006 == ON)
  /** 1..8/16 ; number of active channels used on this ADC            */
   #define ATDFLTR_0_AVERAGECHANNELS   2U  
#endif                 

#if (ADCFLTR_TC007 == ON)
  /** 1..8/16 ; number of active channels used on this ADC            */
   #define ATDFLTR_0_AVERAGECHANNELS   6U  
#endif    

#if ((ADCFLTR_TC001 == ON) || (ADCFLTR_TC002 == ON) || (ADCFLTR_TC003 == ON) || (ADCFLTR_TC004 == ON))
   /** 1..64 ; size of filter - shared among all filters on this ADC    */
   #define ATDFLTR_0_AVERAGETAPS          8U     
#endif

#if ((ADCFLTR_TC005 == ON) || (ADCFLTR_TC009 == ON))
   /** 1..64 ; size of filter - shared among all filters on this ADC    */
   #define ATDFLTR_0_AVERAGETAPS          8U     
#endif

#if (ADCFLTR_TC006 == ON)
   /** 1..64 ; size of filter - shared among all filters on this ADC    */
   #define ATDFLTR_0_AVERAGETAPS          4U     
#endif

 #if (ADCFLTR_TC007 == ON)
    /** 1..8/16 ; number of active channels used on this ADC            */
    #define ATDFLTR_0_AVERAGETAPS      16U  
#endif 

#if (ADCFLTR_TC008 == ON)
   /** 1..64 ; size of filter - shared among all filters on this ADC    */
   #define ATDFLTR_0_AVERAGETAPS          32U     
#endif

/** If TRUE then XGATE interrupts CPU when done                     */
#define ATDFLTR_0_AVERAGEINTERRUPT     1U 

#if (ADCFLTR_TC009 == ON) 
  /** Filter End function used to indicate that all samples were averaged */
  #define ATDFLTR_0_FILTER_FNC           &vfnFilter_1_End_TC_8
#else
  /** Filter End function used to indicate that all samples were averaged */
  #define ATDFLTR_0_FILTER_FNC           &vfnFilter_1_End
#endif

/** Enables or Disables the Error Layer                             */    
#define ADC_FLTR_ERROR_DETECT          ON
/*------------------------------------------- Structures -----------------------------------------------------*/

/** Defines the config structure used for in channel */
typedef struct
{
  uint16_t numTAPS:6;                       /* Number of taps used by this driver                             */
  uint16_t numChannels:4;                   /* Number of channels managed by this driver                      */
  uint16_t interruptCPU:1;                  /* TRUE if CPU should be interrupted at end of thread             */
  void (*AverageEndFnc)(void);              /*  Filter End Interrupt Function                                 */
} tAdcFltr_ChannelConfig;

/** Defines the structure used for each channel */
typedef struct
{
  uint16_t*  pSampleBuffer;    /* Pointer to the stored ATD samples         */
  vuint16_t* pResultRegister;  /* Pointer to the ATD results register       */
  uint16_t   u16AccumulateSample; /* Accumulate samples in time             */
  uint16_t*	 pFilterResult;    /* Pointer to the latest filter output value */
} tAdcFltr_ChannelStruct;

/** Defines the structure used for each ATD */
typedef struct
{
  tAdcFltr_ChannelStruct *channels; /* Array of channelstructs */
  tAdcFltr_ChannelConfig config;
} tAdcFltr_FilterStruct;

/*------------------------------------------- External Variables -----------------------------------------------------*/

extern uint16_t u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS];
extern uint16_t atdfltr_0_channel[ATDFLTR_0_AVERAGECHANNELS][ATDFLTR_0_AVERAGETAPS + 1];	  
extern uint16_t atdfltr_0_FilterResults[ATDFLTR_0_AVERAGECHANNELS];
extern tAdcFltr_FilterStruct sATD0;
extern void vfnFilter_1_End(void);
extern void vfnFilter_1_End_TC_8(void);


